#!/bin/sh
platform_os=`uname -s`

if [ "$platform_os" = "Linux" ];then
    # for rhel5 and SLES10 SP1 installs, lpfcdfc does not exist
    ioctl_driver="lpfcdfc"

    if [ -f /etc/redhat-release ]; then
       rhel_major_version=`cat /etc/redhat-release | awk '{ print $7 }' | awk -F. '{ print $1 }'`

       if [ "$rhel_major_version" -eq 4 ];then
           # is this rhel5 Tikanga release
           rhel5_check=`cat /etc/redhat-release | grep Tikanga`
           if [ -n "$rhel5_check" ];then
               ioctl_driver="lpfc"
           fi
       else
           ioctl_driver="lpfc"
       fi
    elif [ -f /etc/SuSE-release ]; then
       # Check for SLES10 SP1
       sles_major_version=`cat /etc/SuSE-release | grep VERSION | awk '{ print $3 }'`
       if [ "$sles_major_version" -eq 10 ]; then
           sles_minor_version=`cat /etc/SuSE-release | grep PATCHLEVEL | awk '{ print $3 }'`
           if [ -n "$sles_minor_version" ];then
               ioctl_driver="lpfc"
           fi
       fi
    fi
fi

# Start HBAnyware java GUI; JRE is local for Linux installations

pid=`ps -eaf | grep rmiserver.jar | grep -v grep | grep -v start | awk '{ print $2 }' | sort -n | head -1`
if  [ ! -z "$pid" ];then

    if [ "$platform_os" = "Linux" ];then

        # verify driver loaded
        lpfcdfc_loaded=`lsmod | awk '{ print $1 }' | grep "$ioctl_driver"`
        if [ -z "$lpfcdfc_loaded" ];then
            echo ""
            echo " $ioctl_driver module not loaded on machine."
            echo " HBAnyware application requires the $ioctl_driver driver to be loaded."
            echo " Please load $ioctl_driver driver (e.g. modprobe $ioctl_driver) and retry application"
            echo ""
            exit -1
        fi

        kernel_version=`uname -r 2>&1 | awk '{ print $1 }' | awk -F. '{ print $1$2 }'`
        platform_arch=`uname -m`

        # verify libXp loaded on ia64
        if [ "$platform_arch" = "ia64" ];then
           
           # for RH5 and SL10 only
           if [ "$ioctl_driver" = "lpfc" ];then      
           
              # first look in /usr/X11R6
              if [ -d /usr/X11R6/lib ];then
                  libxp_check=`find /usr/X11R6/lib -name libXp.so*`
              fi
    	
              # look in /usr/lib if necessary
              if [ -z "$libxp_check" ];then
                  libxp_check=`find /usr/lib -name libXp.so*`
              fi
           
              if [ -z "$libxp_check" ];then
                   echo ""
                   echo " libXp.so shared object library not loaded on machine."
                   echo " HBAnyware GUI 1.4.2 JRE requires this file to be located in /usr/lib."
                   echo " Please load appropriate RPM package:  libXp-1.0.0-8.ia64.rpm  "
                   echo " from RH5 installation medium or xorg-x11-devel-6.9.0-50.38.ia64.rpm"
                   echo " for SL10. Any dependencies need also be resolved. For SL10, the libXp.so"
                   echo " file is placed into /usr/X11R6/lib and therefore a symbolic link needs be"
                   echo " created from there to /usr/lib or to /usr/sbin/hbanyware/jre/lib"
                   echo ""
                   exit -1
              fi
           fi
        fi
        if [ "$platform_arch" = "ppc64" ];then
            if [ "$kernel_version" = "26" ];then
                # is this 32-bit or 64-bit ppc installation
                jre_check=`file /usr/sbin/hbanyware/jre/bin/java | grep "ELF 32-bit"`
                if [ -n "$jre_check" ];then
                    /usr/sbin/hbanyware/jre/bin/java -Djava.library.path=/usr/lib -jar /usr/sbin/hbanyware/HBAnyware.jar web %%RMI_SERVER_IP%% %%WEB_SERVER_IP%% local > /dev/null
                else
                    /usr/sbin/hbanyware/jre/bin/java -Djava.library.path=/usr/lib64 -jar /usr/sbin/hbanyware/HBAnyware.jar web %%RMI_SERVER_IP%% %%WEB_SERVER_IP%% local > /dev/null
                fi
            else
                /usr/sbin/hbanyware/jre/bin/java -Djava.library.path=/usr/lib -jar /usr/sbin/hbanyware/HBAnyware.jar web %%RMI_SERVER_IP%% %%WEB_SERVER_IP%% local > /dev/null
            fi
        else
            if [ "$platform_arch" = "x86_64" ];then
                /usr/sbin/hbanyware/jre/bin/java -Djava.library.path=/usr/lib64 -jar /usr/sbin/hbanyware/HBAnyware.jar web %%RMI_SERVER_IP%% %%WEB_SERVER_IP%% local > /dev/null 
            else
                /usr/sbin/hbanyware/jre/bin/java -Djava.library.path=/usr/lib -jar /usr/sbin/hbanyware/HBAnyware.jar web %%RMI_SERVER_IP%% %%WEB_SERVER_IP%% local > /dev/null
            fi
        fi
    fi

    if [ "$platform_os" = "SunOS" ];then
        java_version=`java -version 2>&1 | grep version | awk -F\" '{ print $2 }' | awk -F. '{ print $1$2 }'`
        if [ "$java_version" -lt 15 ];then
            echo ""
            echo "Version 1.5 or later of the Java Runtime Environment must be installed."
            echo "HBAnyware will not run under earlier versions of the JRE."
            echo "JRE version can be checked by typing 'java -version' at the command line."
            echo ""
        else
            java -Djava.library.path=/usr/lib -jar /usr/sbin/hbanyware/HBAnyware.jar web %%RMI_SERVER_IP%% %%WEB_SERVER_IP%% local > /dev/null
        fi 
    fi
else
    if [ "$platform_os" = "Linux" ];then

        # verify driver loaded
        lpfcdfc_loaded=`lsmod | awk '{ print $1 }' | grep "$ioctl_driver"`
        if [ -z "$lpfcdfc_loaded" ];then
            echo ""
            echo " $ioctl_driver module not loaded on machine."
            echo " HBAnyware application requires the $ioctl_driver driver to be loaded."
            echo " Please load $ioctl_driver driver (e.g. modprobe $ioctl_driver) and retry application"
            echo ""
            exit -1
        fi

        kernel_version=`uname -r 2>&1 | awk '{ print $1 }' | awk -F. '{ print $1$2 }'`
        platform_arch=`uname -m`

        if [ "$platform_arch" = "ppc64" ];then
           if [ "$kernel_version" = "26" ];then
               # is this 32-bit or 64-bit ppc installation
               jre_check=`file /usr/sbin/hbanyware/jre/bin/java | grep "ELF 32-bit"`
               if [ -n "$jre_check" ];then
                   /usr/sbin/hbanyware/jre/bin/java -Djava.library.path=/usr/lib -jar /usr/sbin/hbanyware/HBAnyware.jar $1 $2 $3
               else
                   /usr/sbin/hbanyware/jre/bin/java -Djava.library.path=/usr/lib64 -jar /usr/sbin/hbanyware/HBAnyware.jar $1 $2 $3
               fi
           else
               /usr/sbin/hbanyware/jre/bin/java -Djava.library.path=/usr/lib -jar /usr/sbin/hbanyware/HBAnyware.jar $1 $2 $3
           fi
        else
            if [ "$platform_arch" = "x86_64" ];then
                /usr/sbin/hbanyware/jre/bin/java -Djava.library.path=/usr/lib64 -jar /usr/sbin/hbanyware/HBAnyware.jar $1 $2 $3 $4
            else
                /usr/sbin/hbanyware/jre/bin/java -Djava.library.path=/usr/lib -jar /usr/sbin/hbanyware/HBAnyware.jar $1 $2 $3
            fi
        fi
    fi

    if [ "$platform_os" = "SunOS" ];then
        java_version=`java -version 2>&1 | grep version | awk -F\" '{ print $2 }' | awk -F. '{ print $1$2 }'`
        if [ "$java_version" -lt 15 ];then
            echo ""
            echo "Version 1.5 or later of the Java Runtime Environment must be installed."
            echo "HBAnyware will not run under earlier versions of the JRE."
            echo "JRE version can be checked by typing 'java -version' at the command line."
            echo ""
        else
            java -Djava.library.path=/usr/lib -jar /usr/sbin/hbanyware/HBAnyware.jar $1 $2 $3 $4
        fi 
    fi
fi
